﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseData_OpcjeWyboru : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {
                options = new List<string>();
                correct = new List<int>();
                answers = new List<int>();
            }

            public int id { get; set; }
            public string text { get; set; }
            public List<string> options { get; set; }
            public List<int> correct { get; set; }
            public List<int> answers { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;

        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }

                return _listStub;
            }
        }

        public GExerciseData_OpcjeWyboru(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
            : base(BLP, ContextParam)
        {
            
        }

        public void Load()
        {
            if (ContextParam.ExerciseOut != null)
            {
                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ABCD: Questions_ABCDLoad(ContextParam.ExerciseOut); break;
                }
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            if (ContextParam.ExerciseIn != null)
            {
                switch (ContextParam.ExerciseIn.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_ABCD: Questions_ABCDCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                }

                SetExerciseOwlSave();
            }
        }

        private void Questions_ABCDLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;
            XmlNode _xmlQuestions = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Questions);
            XmlNodeList _listXmlQuestion = _xmlQuestions.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Question);


            foreach (XmlNode _loopXmlQuestion in _listXmlQuestion)
            {
                _stubIndex++;

                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.options = new List<string>();
                _loopStub.correct = new List<int>();

                int _optionsCounter = 0;

                foreach (XmlNode _loopXml in _loopXmlQuestion.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                    {
                        _loopStub.text = Gemini.Utility.XML.Node.Get.CDATA(_loopXml);
                    }

                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        _optionsCounter++;
                        _loopStub.options.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                        if(Gemini.Utility.XML.Attribute.Get.Int(_loopXml, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.IsAnswerCorrect, 0) ==1)
                        {
                            _loopStub.correct.Add(_optionsCounter);
                        }
                    }
                }

                ExerciseData.Add(_loopStub);
            }
        }


        private void Questions_ABCDCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            Exercise.TmpPoints = 0;

            int _stubIndex = 0;

            bool _isCorrect = false;

            XmlNode _xmlQuestions = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Questions);
            XmlNodeList _listXmlQuestion = _xmlQuestions.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Question);


            foreach (XmlNode _loopXmlQuestion in _listXmlQuestion)
            {
                GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
                GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
                _loopExerciseCheck.id = _stubIndex+1;
       
                foreach (string _exerciseLoop in _loopExerciseDataSave.answers)
                {
                    _isCorrect = false;

                    foreach (XmlNode _loopXmlBox in _loopXmlQuestion.ChildNodes)
                    {
                        if (_loopXmlBox.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                        {
                            if (_exerciseLoop == Gemini.Utility.XML.Node.Get.CDATA(_loopXmlBox))
                            {
                                if (Gemini.Utility.XML.Attribute.Get.Int(_loopXmlBox, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.IsAnswerCorrect, 0) == 1)
                                {
                                    Exercise.TmpPoints++;

                                    _isCorrect = true;
                                    break;
                                }
                            }
                        }
                    }

                    _loopExerciseCheck.success_arr.Add(_isCorrect);
                }

                ExerciseCheck.Add(_loopExerciseCheck);
                _stubIndex++;
            }
        }
    }
}
